<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;
use App\Mail\ContactUsMail;

class EmailController extends Controller
{
    public function contact_us(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'message' => 'required',
            'services' => 'required'
        ]);

        $data = [
            'name' => $request->name,
            'email' => $request->email,
            'service' => $request->services,
            'message' => $request->message,
            'from' => "info@artsnigeria.com",
            'from_name' => "artsnigeria",
        ];

        try {
                $mail = Mail::to('info@artsnigeria.com')->send(new ContactUsMail($data));
         ;
            return redirect()->back()->with('success', 'Form submitted successfully');
        } catch (\Exception $ex) {
            return $ex->getMessage();
        }
    }
}
